;;;                                                                    ;
;;;  R-INFO.LSP                                                        ;
;;;                                                                    ;
;;;  Copyright 1987, 1988, 1990, 1992, 1994, 1996, 1997, 1998, 1999    ;
;;;  by Autodesk, Inc. All Rights Reserved.                            ;
;;;                                                                    ;
;;;  You are hereby granted permission to use, copy and modify this    ;
;;;  software without charge, provided you do so exclusively for       ;
;;;  your own use or for use by others in your organization in the     ;
;;;  performance of their normal duties, and provided further that     ;
;;;  the above copyright notice appears in all copies and both that    ;
;;;  copyright notice and the limited warranty and restricted rights   ;
;;;  notice below appear in all supporting documentation.              ;
;;;                                                                    ;
;;;  Incorporation of any part of this software into other software,   ;
;;;  except when such incorporation is exclusively for your own use    ;
;;;  or for use by others in your organization in the performance of   ;
;;;  their normal duties, is prohibited without the prior written      ;
;;;  consent of Autodesk, Inc.                                         ;
;;;                                                                    ;
;;;  Copying, modification and distribution of this software or any    ;
;;;  part thereof in any form except as expressly provided herein is   ;
;;;  prohibited without the prior written consent of Autodesk, Inc.    ;
;;;                                                                    ;
;;;  AUTODESK PROVIDES THIS SOFTWARE "AS IS" AND WITH ALL FAULTS.      ;
;;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF           ;
;;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,       ;
;;;  INC. DOES NOT WARRANT THAT THE OPERATION OF THE SOFTWARE          ;
;;;  WILL BE UNINTERRUPTED OR ERROR FREE.                              ;
;;;                                                                    ;
;;;  Restricted Rights for US Government Users.  This software         ;
;;;  and Documentation are provided with RESTRICTED RIGHTS for US      ;
;;;  US Government users.  Use, duplication, or disclosure by the      ;
;;;  Government is subject to restrictions as set forth in FAR         ;
;;;  12.212 (Commercial Computer Software-Restricted Rights) and       ;
;;;  DFAR 227.7202 (Rights in Technical Data and Computer Software),   ;
;;;  as applicable.  Manufacturer is Autodesk, Inc., 111 McInnis       ;
;;;  Parkway, San Rafael, California 94903.                            ;
;;;                                                                    ;

;;;--------------------------------------------------------------------;
;;; General Note:  THIS FILE IS A MEMBER OF THE REAC-TST PROJECT       ;
;;;--------------------------------------------------------------------;
;;;  This file contains functions which display information about the  ;
;;;  commands defined within the REAC-TST project file.                ;
;;;                                                                    ;
;;;  For a description of the entire project and a listing of the      ;
;;;  AutoCAD commands defined within it, see the source code file      ;
;;;  REAC-TST.PRJ.                                                     ;
;;;--------------------------------------------------------------------;

;;;--------------------------------------------------------------------;
;;;       Function:  REACT-TEST-INFO-TOPIC                             ;
;;;                                                                    ;
;;;    Description:  This function displays a simple help file in      ;
;;;                  the ACAD Command: prompt.                         ;
;;;                                                                    ;
;;;      Arguments:  topic information in the form of a list of two    ;
;;;                  strings.                                          ;
;;;                                                                    ;
;;; Returned Value:  none                                              ;
;;;                                                                    ;
;;;          Usage: (react-test-info-topic TOPIC-INFO)                 ;
;;;                 or                                                 ;
;;;                 (react-test-info-topic                             ;
;;;                    (car *REACT-TEST-COMMANDS-INFO*))               ;
;;;--------------------------------------------------------------------;
(defun react-test-info-topic (topic-info)
  (princ "\nTo test: ")
  (princ (car topic-info))
  (if (cdr topic-info)
    (progn
      (princ "\tFor information: ")
      (princ (cadr topic-info))
      (if (cddr topic-info)
	(progn
	  (princ "\tTo stop: ")
	  (princ (caddr topic-info))
	)
      )
    )
  )
  (princ)
)
 
;;;--------------------------------------------------------------------;
;;;       Function:  C:REACT-TEST-INFO                                 ;
;;;                                                                    ;
;;;    Description:  This function displays all the simple help file   ;
;;;                  from the global variable                          ;
;;;                  *REACT-TEST-COMMANDS-INFO* to the ACAD            ;
;;;                  Command: prompt.                                  ;
;;;                                                                    ;
;;;      Arguments:  none                                              ;
;;;                                                                    ;
;;; Returned Value:  none                                              ;
;;;                                                                    ;
;;;          Usage: (C:REACT-TEST-INFO) or C:REACT-TEST-INFO from      ;
;;;                 the ACAD Command: prompt.                          ;
;;;--------------------------------------------------------------------;
(defun C:REACT-TEST-INFO ()
  (textscr)
  (foreach topic *REACT-TEST-COMMANDS-INFO*
    (react-test-info-topic topic)
  )
  (princ "\n\nInspect the *REACT-TEST-COMMANDS-INFO* global variable")
  (princ "\nfor the complete list of example commands.  The")
  (princ "\nREACT-TEST-INFO command can be used from the command line.")
  (princ)
)

